/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.Example;
import amf.client.model.domain.NodeShape;
import amf.client.model.domain.Payload;
import amf.client.model.domain.PropertyShape;
import amf.client.model.domain.Shape;
import amf.client.model.domain.UnionShape;
import amf.client.validate.PayloadValidator;
import amf.client.validate.ValidationReport;
import com.sun.jmx.mbeanserver.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.mule.amf.impl.model.MediaType;
import org.mule.amf.impl.model.ParameterImpl;
import org.mule.amf.impl.parser.rule.ValidationResultImpl;
import org.mule.raml.interfaces.model.IMimeType;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.mule.raml.interfaces.parser.rule.IValidationResult;

public class MimeTypeImpl
implements IMimeType {
    private final Payload payload;
    private final Shape shape;
    private final Map<String, Optional<PayloadValidator>> payloadValidatorMap = new HashMap<String, Optional<PayloadValidator>>();
    private final String defaultMediaType;

    public MimeTypeImpl(Payload payload) {
        this.payload = payload;
        this.shape = payload.schema();
        this.defaultMediaType = this.payload.mediaType().option().orElse(null);
    }

    public Object getCompiledSchema() {
        return null;
    }

    public String getSchema() {
        if (this.shape.getClass() == AnyShape.class) {
            return null;
        }
        if (this.shape instanceof AnyShape) {
            return ((AnyShape)this.shape).toJsonSchema();
        }
        return null;
    }

    public Map<String, List<IParameter>> getFormParameters() {
        String mediaType = this.payload.mediaType().value();
        if (mediaType.startsWith("multipart/") || mediaType.equals("application/x-www-form-urlencoded")) {
            if (this.shape.getClass() == AnyShape.class) {
                return Collections.emptyMap();
            }
            if (!(this.shape instanceof NodeShape)) {
                throw new RuntimeException("Unexpected Shape " + this.shape.getClass());
            }
            NodeShape nodeShape = (NodeShape)Util.cast(this.shape);
            LinkedHashMap<String, List<IParameter>> parameters = new LinkedHashMap<String, List<IParameter>>();
            for (PropertyShape propertyShape : nodeShape.properties()) {
                parameters.put(propertyShape.name().value(), Collections.singletonList(new ParameterImpl(propertyShape)));
            }
            return parameters;
        }
        return Collections.emptyMap();
    }

    public String getType() {
        return this.payload.mediaType().value();
    }

    public String getExample() {
        if (this.shape instanceof UnionShape) {
            UnionShape unionShape = (UnionShape)this.shape;
            for (Shape shape : unionShape.anyOf()) {
                String example;
                if (!(shape instanceof AnyShape) || (example = this.getExampleFromAnyShape((AnyShape)shape)) == null) continue;
                return example;
            }
        }
        if (this.shape instanceof AnyShape) {
            return this.getExampleFromAnyShape((AnyShape)this.shape);
        }
        return null;
    }

    private String getExampleFromAnyShape(AnyShape anyShape) {
        Example example2;
        Optional trackedExample = anyShape.trackedExample(this.payload.id());
        if (trackedExample.isPresent() && (example2 = (Example)trackedExample.get()).value().nonNull()) {
            return example2.value().value();
        }
        return anyShape.examples().stream().filter(example -> example.value().value() != null).map(example -> example.value().value()).findFirst().orElse(null);
    }

    public Object getInstance() {
        return null;
    }

    public List<IValidationResult> validate(String payload) {
        Optional<PayloadValidator> payloadValidator;
        String mimeType = MediaType.getMimeTypeForValue(payload);
        if (!this.payloadValidatorMap.containsKey(mimeType)) {
            payloadValidator = this.getPayloadValidator(mimeType);
            if (!payloadValidator.isPresent()) {
                payloadValidator = this.getPayloadValidator(this.defaultMediaType);
            }
            this.payloadValidatorMap.put(mimeType, payloadValidator);
        } else {
            payloadValidator = this.payloadValidatorMap.get(mimeType);
        }
        if (payloadValidator.isPresent()) {
            ValidationReport result;
            try {
                result = (ValidationReport)payloadValidator.get().validate(mimeType, payload).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Unexpected Error validating payload", e);
            }
            return MimeTypeImpl.mapToValidationResult(result);
        }
        throw new RuntimeException("Unexpected Error validating payload");
    }

    private Optional<PayloadValidator> getPayloadValidator(String mediaType) {
        return ((AnyShape)this.shape).payloadValidator(mediaType);
    }

    private static List<IValidationResult> mapToValidationResult(ValidationReport validationReport) {
        if (validationReport.conforms()) {
            return Collections.emptyList();
        }
        return validationReport.results().stream().map(ValidationResultImpl::new).collect(Collectors.toList());
    }
}

