/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.ArrayShape;
import amf.client.model.domain.NodeShape;
import amf.client.model.domain.Parameter;
import amf.client.model.domain.PropertyShape;
import amf.client.model.domain.Shape;
import amf.client.validate.PayloadValidator;
import amf.client.validate.ValidationReport;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.mule.amf.impl.exceptions.UnsupportedSchemaException;
import org.mule.amf.impl.model.MediaType;
import org.mule.amf.impl.model.ParameterImpl;
import org.mule.amf.impl.model.ScalarType;
import org.mule.raml.interfaces.model.IQueryString;
import org.mule.raml.interfaces.model.parameter.IParameter;

public class QueryStringImpl
implements IQueryString {
    private AnyShape schema;
    private boolean required;
    private Collection<String> scalarTypes;
    private final Map<String, Optional<PayloadValidator>> payloadValidatorMap = new HashMap<String, Optional<PayloadValidator>>();
    private final String defaultMediaType = "application/yaml";

    QueryStringImpl(AnyShape anyShape, boolean required) {
        this.schema = anyShape;
        this.required = required;
        List<ScalarType> typeIds = Arrays.asList(ScalarType.values());
        this.scalarTypes = typeIds.stream().map(ScalarType::getName).collect(Collectors.toList());
    }

    private static AnyShape getSchema(Parameter parameter) {
        Shape shape = parameter.schema();
        return QueryStringImpl.castToAnyShape(shape);
    }

    private static AnyShape castToAnyShape(Shape shape) {
        if (shape instanceof AnyShape) {
            return (AnyShape)shape;
        }
        throw new UnsupportedSchemaException();
    }

    public String getDefaultValue() {
        return this.schema.defaultValueStr().option().orElse(null);
    }

    public boolean isArray() {
        return this.schema instanceof ArrayShape;
    }

    public boolean validate(String value) {
        return this.validatePayload(value).conforms();
    }

    private ValidationReport validatePayload(String value) {
        Optional payloadValidator;
        String mimeType = MediaType.getMimeTypeForValue(value);
        if (!this.payloadValidatorMap.containsKey(mimeType)) {
            payloadValidator = this.schema.payloadValidator(mimeType);
            if (!payloadValidator.isPresent()) {
                payloadValidator = this.schema.payloadValidator("application/yaml");
            }
            this.payloadValidatorMap.put(mimeType, payloadValidator);
        } else {
            payloadValidator = this.payloadValidatorMap.get(mimeType);
        }
        if (payloadValidator.isPresent()) {
            try {
                return (ValidationReport)payloadValidator.get().validate(mimeType, value).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Unexpected Error validating request", e);
            }
        }
        throw new RuntimeException("Unexpected Error validating request");
    }

    public boolean isScalar() {
        return this.scalarTypes.contains(this.schema.id());
    }

    public boolean isFacetArray(String facet) {
        if (this.schema instanceof NodeShape) {
            for (PropertyShape type : ((NodeShape)this.schema).properties()) {
                if (!facet.equals(type.name().value())) continue;
                return type.range() instanceof ArrayShape;
            }
        }
        return false;
    }

    public Map<String, IParameter> facets() {
        HashMap<String, IParameter> result = new HashMap<String, IParameter>();
        if (this.schema instanceof NodeShape) {
            for (PropertyShape type : ((NodeShape)this.schema).properties()) {
                result.put(type.name().value(), new ParameterImpl(type));
            }
        }
        return result;
    }
}

