/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.EndPoint;
import amf.client.model.domain.Operation;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.amf.impl.model.ActionImpl;
import org.mule.amf.impl.model.AmfImpl;
import org.mule.amf.impl.model.ParameterImpl;
import org.mule.raml.interfaces.ParserUtils;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IActionType;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.parameter.IParameter;

public class ResourceImpl
implements IResource {
    private AmfImpl amf;
    private EndPoint endPoint;
    private Map<IActionType, IAction> actions;
    private Map<String, IParameter> resolvedUriParameters;

    ResourceImpl(AmfImpl amf, EndPoint endPoint) {
        this.amf = amf;
        this.endPoint = endPoint;
    }

    public String getRelativeUri() {
        return this.endPoint.relativePath();
    }

    public String getUri() {
        return this.endPoint.path().value();
    }

    public String getResolvedUri(String version) {
        return ParserUtils.resolveVersion((String)this.getUri(), (String)version);
    }

    public String getParentUri() {
        return this.getUri().substring(0, this.getUri().length() - this.getRelativeUri().length());
    }

    public IAction getAction(String name) {
        return this.getActions().get(ResourceImpl.getActionKey(name));
    }

    public Map<IActionType, IAction> getActions() {
        if (this.actions == null) {
            this.actions = this.loadActions(this.endPoint);
        }
        return this.actions;
    }

    private Map<IActionType, IAction> loadActions(EndPoint endPoint) {
        LinkedHashMap<IActionType, IAction> map = new LinkedHashMap<IActionType, IAction>();
        endPoint.operations().forEach(operation -> {
            IAction cfr_ignored_0 = map.put(ResourceImpl.getActionKey(operation.method().value()), new ActionImpl(this, (Operation)operation));
        });
        return map;
    }

    private static IActionType getActionKey(String method) {
        return IActionType.valueOf((String)method.toUpperCase());
    }

    public Map<String, IResource> getResources() {
        return this.amf.getResources(this);
    }

    public String getDisplayName() {
        String value = this.endPoint.name().value();
        return value != null ? value : this.getRelativeUri();
    }

    public Map<String, IParameter> getResolvedUriParameters() {
        if (this.resolvedUriParameters == null) {
            this.resolvedUriParameters = ResourceImpl.loadResolvedUriParameters(this.endPoint);
        }
        return this.resolvedUriParameters;
    }

    private static Map<String, IParameter> loadResolvedUriParameters(EndPoint resource) {
        return resource.parameters().stream().filter(p -> !"version".equals(p.name().value())).collect(Collectors.toMap(p -> p.name().value(), ParameterImpl::new));
    }

    public void setParentUri(String parentUri) {
        throw new UnsupportedOperationException();
    }

    public Map<String, List<IParameter>> getBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public void cleanBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getUri();
    }
}

